from typing import Optional

from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.entities.service import Service, ServiceClient, ServiceMerchant
from mail.payments.payments.core.exceptions import CoreActionDenyError, ServiceMerchantNotEnabledError
from mail.payments.payments.storage.exceptions import ServiceNotFound


class AuthServiceMerchantMixin(BaseDBAction):
    service_merchant_id: Optional[int] = None
    service_tvm_id: Optional[int] = None
    service: Optional[Service] = None
    uid: Optional[int] = None

    @property
    def service_client_id(self) -> int:
        assert (
            self.service
            and isinstance(self.service.service_client, ServiceClient)
            and self.service.service_client.service_client_id
        )
        return self.service.service_client.service_client_id

    async def authorize_service_merchant(self) -> None:
        if self.service is None:
            try:
                self.service = await self.storage.service.get_by_related(
                    service_client_tvm_id=self.service_tvm_id,
                    service_merchant_id=self.service_merchant_id,
                )
            except ServiceNotFound:
                raise CoreActionDenyError
        assert isinstance(self.service.service_merchant, ServiceMerchant)
        self.uid = self.service.service_merchant.uid
        if not self.service.service_merchant.enabled:
            raise ServiceMerchantNotEnabledError

    async def pre_handle(self) -> None:
        await self.authorize_service_merchant()
        await super().pre_handle()
