from mail.payments.payments.conf import settings
from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.actions.transact_email import TransactEmailAction
from mail.payments.payments.core.entities.merchant import Merchant
from mail.payments.payments.core.entities.service import Service, ServiceMerchant


class NotifyMixin(BaseDBAction):
    async def notify_merchant_on_sm_created_enabled(self,
                                                    service: Service,
                                                    service_merchant: ServiceMerchant,
                                                    merchant: Merchant) -> None:
        """
        Schedule email notification of merchant when service_merchant created or enabled

        Args:
            merchant: merchant with pre-loaded contact data
            service: service to be attached to merchant
            service_merchant: created relation between service and merchant
        """
        assert service_merchant.service_id == service.service_id
        mailing_id = settings.SENDER_MAILING_SERVICE_MERCHANT_CREATED
        render_context = {
            'service': {
                'service_id': service.service_id,
                'name': service.name,
            },
            'service_merchant': {
                'service_merchant_id': service_merchant.service_merchant_id,
                'description': service_merchant.description,
                'entity_id': service_merchant.entity_id,
                'enabled': service_merchant.enabled,
            }
        }

        if contact := merchant.contact:
            await TransactEmailAction(
                to_email=contact.email,
                render_context=render_context,
                mailing_id=mailing_id,
            ).run_async()
