from dataclasses import dataclass, field
from enum import Enum
from typing import List, Optional


class MonitoringVerdict(Enum):
    OK = 'ok'
    WARN = 'warn'
    CRIT = 'crit'


@dataclass
class MonitoringStatus:
    verdict: MonitoringVerdict
    errors: List[str] = field(default_factory=list)
    message: Optional[str] = None
