from mail.payments.payments.core.actions.base.action import BaseAction
from mail.payments.payments.core.entities.enums import TrustEnv
from mail.payments.payments.core.entities.order import Order


class GetOrderTrustEnvAction(BaseAction):
    def __init__(self, order: Order):
        assert order.shop is not None
        super().__init__()
        self.order = order

    async def handle(self) -> TrustEnv:
        shop_type = self.order.shop.shop_type if self.order.shop is not None else None
        return self.clients.get_trust_client(self.order.uid, shop_type).env
