from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.entities.service import ServiceClient
from mail.payments.payments.core.exceptions import ServiceNotFoundError
from mail.payments.payments.storage.exceptions import ServiceNotFound


class CreateServiceClientAction(BaseDBAction):
    transact = True

    def __init__(self, service_id: int, tvm_id: int, api_callback_url: str):
        super().__init__()
        self.service_id: int = service_id
        self.tvm_id: int = tvm_id
        self.api_callback_url: str = api_callback_url

    async def handle(self) -> ServiceClient:
        try:
            await self.storage.service.get(self.service_id)
        except ServiceNotFound:
            raise ServiceNotFoundError(service_id=self.service_id)
        return await self.storage.service_client.create(ServiceClient(
            service_id=self.service_id,
            tvm_id=self.tvm_id,
            api_callback_url=self.api_callback_url,
        ))
