from typing import Optional

from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.entities.service import Service, ServiceMerchant
from mail.payments.payments.core.exceptions import ServiceMerchantNotFoundError, ServiceNotFoundError
from mail.payments.payments.storage.exceptions import ServiceMerchantNotFound, ServiceNotFound


class BaseServiceMerchantAction(BaseDBAction):
    async def get_service(self, service_tvm_id: int, service_merchant_id: Optional[int] = None) -> Service:
        try:
            return await self.storage.service.get_by_related(
                service_client_tvm_id=service_tvm_id,
                service_merchant_id=service_merchant_id,
            )
        except ServiceNotFound:
            raise ServiceNotFoundError(tvm_id=service_tvm_id)

    async def get_service_merchant(self, service_merchant_id: int, uid: int) -> ServiceMerchant:
        try:
            return await self.storage.service_merchant.get(service_merchant_id, uid=uid)
        except ServiceMerchantNotFound:
            raise ServiceMerchantNotFoundError(service_merchant_id=service_merchant_id, uid=uid)
