from mail.payments.payments.core.actions.service_merchant.base import BaseServiceMerchantAction
from mail.payments.payments.core.entities.change_log import ChangeLog
from mail.payments.payments.core.entities.enums import MerchantRole, OperationKind
from mail.payments.payments.core.entities.service import ServiceMerchant


class DeleteServiceMerchantAction(BaseServiceMerchantAction):
    """Used by merchant"""
    transact = True
    required_merchant_roles = (MerchantRole.ADMIN,)

    def __init__(self, service_merchant_id: int, uid: int):
        super().__init__()
        self.service_merchant_id: int = service_merchant_id
        self.uid: int = uid

    async def handle(self) -> ServiceMerchant:
        service_merchant = await self.get_service_merchant(
            service_merchant_id=self.service_merchant_id,
            uid=self.uid,
        )
        service_merchant = await self.storage.service_merchant.delete(service_merchant)

        # Logging
        assert service_merchant.revision
        await self.storage.change_log.create(ChangeLog(
            uid=self.uid,
            revision=service_merchant.revision,
            operation=OperationKind.DELETE_SERVICE_MERCHANT,
            arguments={'service_id': service_merchant.service_id,
                       'service_merchant_id': service_merchant.service_merchant_id}
        ))
        self.logger.context_push(service_merchant_id=service_merchant.service_merchant_id,
                                 uid=service_merchant.uid,
                                 service_id=service_merchant.service_id
                                 )
        self.logger.info('Service_merchant deleted')

        return service_merchant


class DeleteServiceMerchantServiceAction(BaseServiceMerchantAction):
    """Used by service"""
    transact = True

    def __init__(self, service_merchant_id: int, service_tvm_id: int):
        super().__init__()
        self.service_merchant_id: int = service_merchant_id
        self.service_tvm_id: int = service_tvm_id

    async def handle(self) -> ServiceMerchant:
        service = await self.get_service(
            service_merchant_id=self.service_merchant_id,
            service_tvm_id=self.service_tvm_id
        )
        service_merchant = service.service_merchant
        assert isinstance(service_merchant, ServiceMerchant)
        service_merchant = await self.storage.service_merchant.delete(service_merchant)

        # Logging
        assert service_merchant.revision
        await self.storage.change_log.create(ChangeLog(
            uid=service_merchant.uid,
            revision=service_merchant.revision,
            operation=OperationKind.DELETE_SERVICE_MERCHANT,
            arguments={
                'service_id': service_merchant.service_id,
                'service_merchant_id': service_merchant.service_merchant_id
            }
        ))

        self.logger.context_push(
            service_merchant_id=service_merchant.service_merchant_id,
            uid=service_merchant.uid,
            service_id=service_merchant.service_id,
            tvm_id=self.service_tvm_id
        )
        self.logger.info('Service_merchant deleted')

        return service_merchant
