from typing import List

from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.actions.service_merchant.base import BaseServiceMerchantAction
from mail.payments.payments.core.entities.enums import MerchantRole
from mail.payments.payments.core.entities.not_fetched import NOT_FETCHED
from mail.payments.payments.core.entities.service import ServiceMerchant


class GetServiceMerchantListAction(BaseDBAction):
    required_merchant_roles = (MerchantRole.VIEWER,)

    def __init__(self, uid: int):
        super().__init__()
        self.uid: int = uid

    async def handle(self) -> List[ServiceMerchant]:
        return [
            service_merchant
            async for service_merchant in self.storage.service_merchant.find(
                uid=self.uid,
                with_service=True,
            )
        ]


class GetServiceMerchantAction(BaseServiceMerchantAction):
    required_merchant_roles = (MerchantRole.VIEWER,)

    def __init__(self, service_merchant_id: int, uid: int):
        super().__init__()
        self.service_merchant_id: int = service_merchant_id
        self.uid: int = uid

    async def handle(self) -> ServiceMerchant:
        return await self.get_service_merchant(
            service_merchant_id=self.service_merchant_id,
            uid=self.uid,
        )


class GetServiceMerchantServiceAction(BaseServiceMerchantAction):
    def __init__(self, service_merchant_id: int, service_tvm_id: int):
        super().__init__()
        self.service_merchant_id: int = service_merchant_id
        self.service_tvm_id: int = service_tvm_id

    async def handle(self) -> ServiceMerchant:
        service = await self.get_service(
            service_merchant_id=self.service_merchant_id,
            service_tvm_id=self.service_tvm_id,
        )
        service_merchant = service.service_merchant
        assert isinstance(service_merchant, ServiceMerchant)
        service.service_merchant = NOT_FETCHED
        service_merchant.service = service
        return service_merchant
