from typing import Any, List, Optional

from sendr_utils import alist

from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.entities.enums import MerchantRole
from mail.payments.payments.core.entities.shop import Shop


class CoreGetShopListAction(BaseDBAction):
    def __init__(self, uid: int, limit: Optional[int] = None, offset: Optional[int] = None,
                 with_merchant_oauth: bool = False):
        super().__init__()
        self.uid = uid
        self.limit = limit
        self.offset = offset
        self.with_merchant_oauth = with_merchant_oauth

    async def handle(self) -> List[Shop]:
        return await alist(
            self.storage.shop.find(
                uid=self.uid,
                limit=self.limit,
                offset=self.offset,
                order=('uid', 'shop_id'),
                with_merchant_oauth=self.with_merchant_oauth,
            )
        )


class GetShopListAction(BaseDBAction):
    required_merchant_roles = (MerchantRole.VIEWER,)

    def __init__(self, **kwargs: Any):
        super().__init__()
        self.kwargs = kwargs

    async def handle(self) -> List[Shop]:
        return await CoreGetShopListAction(**self.kwargs).run()
