from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.actions.mixins.auth_service_merchant import AuthServiceMerchantMixin
from mail.payments.payments.core.actions.subscription.base import BaseSubscriptionAction
from mail.payments.payments.core.entities.enums import MerchantRole
from mail.payments.payments.core.entities.subscription import Subscription
from mail.payments.payments.core.exceptions import EnabledCustomerSubscriptionExistsError


class CoreDeleteSubscriptionAction(BaseSubscriptionAction):
    transact = True
    subscription_for_update = True
    subscription_skip_moderation = True

    def __init__(self,
                 uid: int,
                 subscription_id: int,
                 ):
        super().__init__(uid=uid, subscription_id=subscription_id)

    async def handle(self) -> Subscription:
        assert self.subscription and self.subscription.subscription_id

        enabled_customer_subscriptions_count = await self.storage.customer_subscription.count_enabled(
            uid=self.subscription.uid,
            subscription_id=self.subscription.subscription_id
        )
        if enabled_customer_subscriptions_count > 0:
            raise EnabledCustomerSubscriptionExistsError

        self.subscription.deleted = True
        return await self.storage.subscription.save(self.subscription)


class DeleteSubscriptionAction(BaseDBAction):
    required_merchant_roles = (MerchantRole.OPERATOR,)

    def __init__(self,
                 uid: int,
                 subscription_id: int,
                 ):
        self.uid = uid
        self.subscription_id = subscription_id
        super().__init__()

    async def handle(self) -> Subscription:
        return await CoreDeleteSubscriptionAction(uid=self.uid, subscription_id=self.subscription_id).run()


class DeleteSubscriptionServiceMerchantAction(AuthServiceMerchantMixin, BaseDBAction):
    def __init__(self,
                 service_tvm_id: int,
                 service_merchant_id: int,
                 subscription_id: int,
                 ):
        super().__init__()
        self.service_tvm_id: int = service_tvm_id
        self.service_merchant_id: int = service_merchant_id
        self.subscription_id: int = subscription_id

    async def handle(self) -> Subscription:
        assert self.uid
        return await CoreDeleteSubscriptionAction(uid=self.uid, subscription_id=self.subscription_id).run()
