from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.actions.mixins.auth_service_merchant import AuthServiceMerchantMixin
from mail.payments.payments.core.actions.subscription.base import BaseSubscriptionAction
from mail.payments.payments.core.entities.enums import MerchantRole
from mail.payments.payments.core.entities.subscription import Subscription


class CoreGetSubscriptionAction(BaseSubscriptionAction):
    def __init__(self,
                 uid: int,
                 subscription_id: int,
                 ):
        super().__init__(uid=uid, subscription_id=subscription_id)

    async def handle(self) -> Subscription:
        assert self.subscription
        assert self.uid

        self.subscription.enabled_customer_subscriptions = \
            await self.storage.customer_subscription.count_enabled(self.uid, self.subscription_id)
        return self.subscription


class GetSubscriptionAction(BaseDBAction):
    required_merchant_roles = (MerchantRole.VIEWER,)

    def __init__(self,
                 uid: int,
                 subscription_id: int,
                 ):
        super().__init__()
        self.uid = uid
        self.subscription_id = subscription_id

    async def handle(self) -> Subscription:
        return await CoreGetSubscriptionAction(uid=self.uid, subscription_id=self.subscription_id).run()


class GetSubscriptionServiceMerchantAction(AuthServiceMerchantMixin, BaseDBAction):
    def __init__(self,
                 service_tvm_id: int,
                 service_merchant_id: int,
                 subscription_id: int,
                 ):
        super().__init__()
        self.service_tvm_id: int = service_tvm_id
        self.service_merchant_id: int = service_merchant_id
        self.subscription_id: int = subscription_id

    async def handle(self) -> Subscription:
        assert self.uid
        return await CoreGetSubscriptionAction(uid=self.uid, subscription_id=self.subscription_id).run()
