from typing import Iterable, Optional

from sendr_utils import alist

from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.actions.mixins.auth_service_merchant import AuthServiceMerchantMixin
from mail.payments.payments.core.entities.enums import MerchantRole
from mail.payments.payments.core.entities.subscription import Subscription


class CoreGetSubscriptionListAction(BaseDBAction):
    def __init__(self,
                 uid: Optional[int] = None,
                 limit: Optional[int] = None,
                 offset: Optional[int] = None,
                 ):
        super().__init__()
        self.uid: Optional[int] = uid
        self.limit: Optional[int] = limit
        self.offset: Optional[int] = offset

    async def handle(self) -> Iterable[Subscription]:
        return await alist(self.storage.subscription.find(uid=self.uid, limit=self.limit, offset=self.offset))


class GetSubscriptionListAction(BaseDBAction):
    required_merchant_roles = (MerchantRole.VIEWER,)

    def __init__(self,
                 uid: Optional[int] = None,
                 limit: Optional[int] = None,
                 offset: Optional[int] = None,
                 ):
        super().__init__()
        self.uid: Optional[int] = uid
        self.limit: Optional[int] = limit
        self.offset: Optional[int] = offset

    async def handle(self) -> Iterable[Subscription]:
        return await CoreGetSubscriptionListAction(uid=self.uid, limit=self.limit, offset=self.offset).run()


class GetSubscriptionListServiceMerchantAction(AuthServiceMerchantMixin, BaseDBAction):
    def __init__(self,
                 service_tvm_id: int,
                 service_merchant_id: int,
                 limit: Optional[int] = None,
                 offset: Optional[int] = None,
                 ):
        super().__init__()
        self.service_tvm_id: int = service_tvm_id
        self.service_merchant_id: int = service_merchant_id
        self.limit: Optional[int] = limit
        self.offset: Optional[int] = offset

    async def handle(self) -> Iterable[Subscription]:
        return await CoreGetSubscriptionListAction(uid=self.uid, limit=self.limit, offset=self.offset).run()
