from typing import Optional

from mail.payments.payments.core.actions.base.action import BaseAction
from mail.payments.payments.core.actions.tlog.schemas import BaseSchema
from mail.payments.payments.storage.logbroker.producers.tlog import TLogLogbrokerProducer


class WriteToTLogAction(BaseAction):
    def __init__(self, data: dict, schema: Optional[BaseSchema] = None):
        super().__init__()
        self.data = data
        self.schema = schema

    async def handle(self) -> None:
        data = self.data
        if self.schema is not None:
            data, _ = self.schema.dump(data)

        async with TLogLogbrokerProducer(self.context.lb_factory) as producer:
            await producer.write_dict(data=data)
