from mail.payments.payments.core.actions.user_role.base import BaseUserRoleAction
from mail.payments.payments.core.entities.enums import MerchantRole
from mail.payments.payments.core.exceptions import RoleDeletionNotAllowed, UserRoleNotFoundError
from mail.payments.payments.storage.exceptions import UserRoleNotFound


class DeleteUserRoleAction(BaseUserRoleAction):
    transact = True
    required_merchant_roles = (MerchantRole.ADMIN,)

    async def handle(self) -> None:
        assert any((self.user_uid, self.user_email)), 'Either email or uid required'

        user_uid = self.user_uid
        if self.user_email is not None:
            userinfo = await self.get_userinfo(login=self.user_email)
            user_uid = userinfo.uid
        try:
            assert user_uid is not None
            user_role = await self.storage.user_role.get(uid=user_uid,
                                                         merchant_id=self.merchant_id,
                                                         for_update=True)
        except UserRoleNotFound:
            raise UserRoleNotFoundError(uid=user_uid, merchant_id=self.merchant_id)

        if user_role.role == MerchantRole.OWNER:
            raise RoleDeletionNotAllowed
        await self.storage.user_role.delete(user_role)
