import logging
from typing import Optional

from sendr_aiopg.engine.single import CustomEngine
from sendr_core.context import BaseCoreContext

from mail.payments.payments.core.entities.merchant_user import MerchantUser
from mail.payments.payments.http_helpers.crypto import Crypto
from mail.payments.payments.http_helpers.partner_crypto import PartnerCrypto
from mail.payments.payments.storage import Storage
from mail.payments.payments.storage.logbroker.factory import LogbrokerFactory
from mail.payments.payments.storage.writers import PaymentsPushers

default_logger = logging.getLogger('context_logger')


class CoreContext(BaseCoreContext):
    db_engine: CustomEngine
    pushers: PaymentsPushers
    crypto: Crypto
    partner_crypto: Optional[PartnerCrypto] = None
    storage: Optional[Storage] = None
    merchant_user: Optional[MerchantUser] = None
    lb_factory: LogbrokerFactory
