from dataclasses import dataclass, field
from datetime import datetime
from typing import Optional

from sendr_aiopg import Entity
from sendr_utils import utcnow

from mail.payments.payments.core.entities.enums import ArbitrageStatus, ArbitrageVerdict


@dataclass
class Arbitrage(Entity):
    uid: int
    order_id: int
    arbitrage_id: Optional[int] = None  # AI

    consultation_id: Optional[str] = None  # айди консультации с покупателем
    chat_id: Optional[str] = None  # айди чата с покупателем
    arbiter_chat_id: Optional[str] = None  # айди чата мерчант-арбитр
    escalate_id: Optional[int] = None  # айди арбитража в системе Арбитража
    refund_id: Optional[int] = None
    status: ArbitrageStatus = ArbitrageStatus.CONSULTATION
    verdict: Optional[ArbitrageVerdict] = None

    created: datetime = field(default_factory=utcnow)
    updated: datetime = field(default_factory=utcnow)

    @property
    def is_active(self) -> bool:
        return self.status in ArbitrageStatus.ACTIVE_STATUSES  # type: ignore
