from dataclasses import dataclass
from datetime import datetime
from typing import Optional

from sendr_aiopg import Entity

from mail.payments.payments.core.entities.enums import AcquirerType


@dataclass
class Category(Entity):
    title: str
    category_id: Optional[int] = None
    required_acquirer: Optional[AcquirerType] = None
    created: Optional[datetime] = None
    updated: Optional[datetime] = None
