from dataclasses import dataclass, field
from datetime import datetime
from typing import Optional

from mail.payments.payments.core.entities.enums import OperationKind
from mail.payments.payments.utils.datetime import utcnow


@dataclass
class ChangeLog:
    uid: int
    revision: int
    operation: OperationKind
    arguments: Optional[dict] = None
    info: Optional[dict] = None
    changed_at: datetime = field(default_factory=utcnow)
