from dataclasses import dataclass, field
from datetime import datetime
from typing import Optional

from sendr_aiopg import Entity
from sendr_utils import utcnow

from mail.payments.payments.core.entities.enums import CommonDataType


@dataclass
class SearchStats:
    total: int
    found: int


@dataclass
class CommonData(Entity):
    data_type: CommonDataType
    common_data_id: Optional[int] = None
    payload: dict = field(default_factory=dict)
    created: datetime = field(default_factory=utcnow)
