from dataclasses import dataclass, field
from datetime import datetime
from typing import Optional

from mail.payments.payments.core.entities.enums import AcquirerType
from mail.payments.payments.core.entities.subscription import Subscription
from mail.payments.payments.utils.datetime import utcnow


@dataclass
class CustomerSubscription:
    uid: int
    subscription_id: int

    quantity: int

    region_id: int
    user_ip: Optional[str] = None

    enabled: bool = False
    time_until: datetime = field(default_factory=utcnow)
    time_finish: Optional[datetime] = None

    customer_subscription_id: Optional[int] = None
    service_merchant_id: Optional[int] = None
    service_client_id: Optional[int] = None

    created: Optional[datetime] = None
    updated: Optional[datetime] = None
    order_id: Optional[int] = None

    # Joined
    subscription: Optional[Subscription] = None

    @property
    def acquirer(self) -> Optional[AcquirerType]:
        if self.subscription is not None:
            return self.subscription.acquirer
        return None
