from dataclasses import dataclass
from datetime import datetime
from typing import Optional

from mail.payments.payments.core.entities.enums import TransactionStatus


@dataclass
class CustomerSubscriptionTransaction:
    uid: int
    customer_subscription_id: int
    purchase_token: str

    payment_status: TransactionStatus
    data: Optional[dict] = None
    created: Optional[datetime] = None
    updated: Optional[datetime] = None
    trust_order_id: Optional[str] = None
