from dataclasses import dataclass, field
from datetime import datetime
from typing import Optional

from mail.payments.payments.utils.datetime import utcnow

from .enums import DocumentType


@dataclass
class Document:
    document_type: DocumentType
    path: str
    size: int
    name: Optional[str] = None

    created: datetime = field(default_factory=utcnow)

    moderation_url: Optional[str] = None
