from dataclasses import dataclass
from datetime import datetime
from typing import Optional

from sendr_aiopg import Entity

from mail.payments.payments.conf import settings


@dataclass
class ImageSizes:
    path: str

    @property
    def orig(self):
        return self.path + '/orig'


@dataclass
class Image(Entity):
    uid: int
    url: str
    md5: Optional[str] = None
    sha256: Optional[str] = None
    image_id: Optional[int] = None
    stored_path: Optional[str] = None
    created: Optional[datetime] = None
    updated: Optional[datetime] = None

    @property
    def downloaded(self):
        return self.stored_path is not None

    @property
    def stored(self) -> Optional[ImageSizes]:
        if self.stored_path is not None:
            base_url = settings.AVATARS_READ_URL.rstrip('/')
            return ImageSizes(f'{base_url}/{self.stored_path}')
        return None
