from dataclasses import dataclass, field
from datetime import datetime
from typing import Optional

from mail.payments.payments.core.entities.enums import Role
from mail.payments.payments.utils.datetime import utcnow


@dataclass
class Manager:
    uid: int
    domain_login: str
    created: datetime = field(default_factory=utcnow)
    updated: datetime = field(default_factory=utcnow)


@dataclass
class ManagerRole:
    manager_uid: int
    role: Role
    created: datetime = field(default_factory=utcnow)
    updated: datetime = field(default_factory=utcnow)

    # joined
    manager: Optional[Manager] = None
