from dataclasses import dataclass
from typing import Optional, Union

from mail.payments.payments.core.entities.enums import MerchantRole
from mail.payments.payments.core.entities.not_fetched import NOT_FETCHED, NotFetchedType
from mail.payments.payments.core.entities.user import User
from mail.payments.payments.core.entities.user_role import UserRole


@dataclass
class MerchantUser:
    """Contains information about a user performing an action.
    Passed between actions during request handling.
    """
    user_uid: int
    merchant_id: str
    user: Union[NotFetchedType, Optional[User]] = NOT_FETCHED
    user_role: Union[NotFetchedType, Optional[UserRole]] = NOT_FETCHED

    @property
    def user_merchant_role(self) -> Optional[MerchantRole]:
        assert not isinstance(self.user_role, NotFetchedType), 'user_role must be fetched first'
        return None if self.user_role is None else self.user_role.role
