from dataclasses import dataclass
from datetime import datetime
from decimal import Decimal
from typing import Optional, Tuple

from mail.payments.payments.core.entities.enums import NDS, ProductStatus

ProductKeyType = Tuple[str, NDS, str, Decimal]


@dataclass
class Product:
    uid: int
    name: str
    price: Decimal
    nds: NDS
    product_id: Optional[int] = None
    verified: bool = False
    created: Optional[datetime] = None
    status: ProductStatus = ProductStatus.ACTIVE
    currency: str = 'RUB'
    revision: Optional[int] = None

    @property
    def key(self) -> ProductKeyType:
        return self.name, self.nds, self.currency, self.price

    @property
    def key_out(self) -> Tuple[str, str, str, float]:
        return self.name, str(self.nds.value), self.currency, float(round(self.price, 2))

    def adjust_nds(self):
        if self.nds == NDS.NDS_18:
            self.nds = NDS.NDS_20
        if self.nds == NDS.NDS_18_118:
            self.nds = NDS.NDS_20_120
