from dataclasses import dataclass, field
from datetime import datetime
from typing import Optional, Union

from sendr_utils import utcnow

from mail.payments.payments.core.entities.enums import ShopType
from mail.payments.payments.core.entities.merchant_oauth import MerchantOAuth
from mail.payments.payments.core.entities.not_fetched import NOT_FETCHED, NotFetchedType


@dataclass
class ShopSettings:
    # empty for now, probably will have data like
    # callback_url: str
    pass


@dataclass
class Shop:
    """
    Shop entity allows to logically separate orders into different groups within one merchant.
    Each order belongs to some shop specified by shop_id order's attribute.

    Default shop is required for backward compatibility with clients, who does not send
    X-Shop-Id header yet. That is why each merchant can have only one default shop.
    """

    uid: int
    name: str
    is_default: bool
    shop_type: ShopType
    settings: ShopSettings = field(default_factory=ShopSettings)

    shop_id: Optional[int] = None

    created: datetime = field(default_factory=utcnow)
    updated: datetime = field(default_factory=utcnow)

    oauth: Union[NotFetchedType, Optional[MerchantOAuth]] = NOT_FETCHED
