from dataclasses import dataclass, field
from datetime import datetime
from typing import Dict, Optional

from sendr_aiopg.storage import Entity

from mail.payments.payments.utils.datetime import utcnow

from .enums import TaskState, TaskType


@dataclass
class Task(Entity):
    task_type: TaskType
    task_id: Optional[int] = None
    params: Optional[Dict] = None

    state: TaskState = TaskState.PENDING
    retries: int = 0
    details: dict = field(default_factory=dict)

    action_name: Optional[str] = None

    run_at: datetime = field(default_factory=utcnow)
    created: Optional[datetime] = field(default_factory=utcnow)
    updated: Optional[datetime] = field(default_factory=utcnow)
