from dataclasses import dataclass, field
from datetime import datetime
from typing import Optional, Union

from mail.payments.payments.core.entities.enums import MerchantRole
from mail.payments.payments.core.entities.merchant import Merchant
from mail.payments.payments.core.entities.not_fetched import NOT_FETCHED, NotFetchedType
from mail.payments.payments.core.entities.user import User
from mail.payments.payments.utils.datetime import utcnow


@dataclass
class UserRole:
    uid: int
    merchant_id: str
    role: MerchantRole
    created: datetime = field(default_factory=utcnow)
    updated: datetime = field(default_factory=utcnow)
    description: Optional[str] = None
    email: Optional[str] = None

    # Joined
    user: Union[NotFetchedType, User] = field(default=NOT_FETCHED, compare=False)
    merchant: Union[NotFetchedType, Merchant] = field(default=NOT_FETCHED, compare=False)
