from dataclasses import dataclass
from datetime import datetime
from typing import Optional

from sendr_aiopg.storage import Entity

from .enums import WorkerState, WorkerType


@dataclass
class Worker(Entity):
    worker_id: str
    worker_type: WorkerType
    host: str
    state: WorkerState
    heartbeat: Optional[datetime] = None
    startup: Optional[datetime] = None
    task_id: Optional[int] = None
