from typing import Optional

import sendr_interactions

from mail.payments.payments.conf import settings
from mail.payments.payments.core.entities.enums import ShopType
from mail.payments.payments.interactions.arbiter import ArbiterClient
from mail.payments.payments.interactions.avatars import AvatarsClient
from mail.payments.payments.interactions.balance import BalanceClient
from mail.payments.payments.interactions.balance_http import BalanceHttpClient
from mail.payments.payments.interactions.base import AbstractInteractionClient
from mail.payments.payments.interactions.blackbox import BlackBoxClient, BlackBoxCorpClient
from mail.payments.payments.interactions.callback import CallbackClient
from mail.payments.payments.interactions.developer import DeveloperClient
from mail.payments.payments.interactions.floyd import FloydClient
from mail.payments.payments.interactions.geobase import GeobaseClient
from mail.payments.payments.interactions.kassa import KassaClient
from mail.payments.payments.interactions.mds import ModerationMDSClient, PaymentsMDSClient
from mail.payments.payments.interactions.oauth import OAuthClient
from mail.payments.payments.interactions.ohio import OhioClient
from mail.payments.payments.interactions.refs import RefsClient
from mail.payments.payments.interactions.search_wizard import SearchWizardClient
from mail.payments.payments.interactions.sender import SenderClient
from mail.payments.payments.interactions.so import SoClient
from mail.payments.payments.interactions.spark import SparkClient
from mail.payments.payments.interactions.spark_suggest import SparkSuggestClient
from mail.payments.payments.interactions.tinkoff import TinkoffClient
from mail.payments.payments.interactions.trust import BaseTrustClient, TrustProductionClient, TrustSandboxClient
from mail.payments.payments.interactions.yandex_pay_admin import YandexPayAdminClient
from mail.payments.payments.interactions.zora_images import ZoraImagesClient


class InteractionClients(sendr_interactions.InteractionClients):
    abstract_client_class = AbstractInteractionClient

    arbiter: ArbiterClient
    avatars: AvatarsClient
    balance: BalanceClient
    balance_http: BalanceHttpClient
    blackbox: BlackBoxClient
    blackbox_corp: BlackBoxCorpClient
    callback: CallbackClient
    developer: DeveloperClient
    floyd: FloydClient
    geobase: GeobaseClient
    kassa: KassaClient
    moderation_mds: ModerationMDSClient
    oauth: OAuthClient
    ohio: OhioClient
    payments_mds: PaymentsMDSClient
    refs: RefsClient
    search_wizard: SearchWizardClient
    sender: SenderClient
    so: SoClient
    spark: SparkClient
    spark_suggest: SparkSuggestClient
    tinkoff: TinkoffClient
    trust_production: TrustProductionClient
    trust_sandbox: TrustSandboxClient
    yandex_pay_admin: YandexPayAdminClient
    zora_images: ZoraImagesClient

    def get_trust_client(self, uid: int, shop_type: Optional[ShopType]) -> BaseTrustClient:
        assert shop_type is None or isinstance(shop_type, ShopType)
        if (
            settings.TRUST_SANDBOX_PAYMENTS
            or BaseTrustClient.get_merchant_setting(uid, 'trust_sandbox_payments', False)
        ) and shop_type == ShopType.TEST:
            return self.trust_sandbox
        return self.trust_production
