from dataclasses import dataclass
from datetime import datetime
from typing import Optional


@dataclass
class Person:
    client_id: str
    person_id: Optional[str]

    account: str
    bik: str
    fname: str
    lname: str
    email: str
    phone: str

    name: str
    longname: str
    inn: str
    kpp: Optional[str]
    ogrn: str

    legal_address_city: str
    legal_address_home: str
    legal_address_postcode: str
    legal_address_street: str

    mname: Optional[str] = None

    address_city: Optional[str] = None
    address_home: Optional[str] = None
    address_postcode: Optional[str] = None
    address_street: Optional[str] = None

    date: Optional[datetime] = None

    @property
    def has_post_address(self) -> bool:
        return not any((
            self.address_city is None,
            self.address_home is None,
            self.address_postcode is None,
            self.address_street is None,
        ))
