import json
from typing import Optional

from aiohttp import ClientResponse

from mail.payments.payments.conf import settings
from mail.payments.payments.interactions.base import AbstractInteractionClient


class BalanceHttpClient(AbstractInteractionClient):
    SERVICE = 'balance'
    BASE_URL = settings.BALANCE_HTTP_URL.rstrip('/')
    TVM_ID = settings.TVM_BALANCE_CLIENT_ID

    async def get_payouts_by_purchase_token(self, purchase_token: Optional[str]) -> dict:
        return await self.get(
            'get_payouts_by_purchase_token',
            self.endpoint_url('get_payouts_by_purchase_token'),
            params={'purchase_token': purchase_token},
        )

    async def _process_response(self, response: ClientResponse, interaction_method: str) -> dict:
        if response.status >= 400:
            await self._handle_response_error(response)
        return json.loads(await response.read())
