from typing import ClassVar

from sendr_interactions import exceptions as interaction_errors


class BaseDeveloperError(interaction_errors.BaseInteractionError):
    MESSAGE: ClassVar[str] = ''

    def __init__(self, *, method='GET', message=MESSAGE):
        super().__init__(service='developer', method=method, message=message)


class DeveloperKeyAccessDeny(BaseDeveloperError):
    pass


class DeveloperServiceNotFound(BaseDeveloperError):
    MESSAGE = 'Developer service not found'
