from typing import Optional

from multidict import MultiDict

from sendr_interactions import exceptions as interaction_errors


class BlackBoxUserNotFoundError(interaction_errors.BaseInteractionError):
    default_message = 'User not found'


class BlackBoxDefaultEmailNotFoundError(interaction_errors.BaseInteractionError):
    default_message = 'Default email not found'


# Tinkoff
class TinkoffError(interaction_errors.BaseInteractionError):
    params: Optional[MultiDict] = None

    def __init__(self, *, method, message=None, params=None):
        if params is not None:
            self.params = params
        super().__init__(service='tinkoff', method=method, message=message)


class TinkoffDataError(TinkoffError):
    pass


class TinkoffAddressError(TinkoffDataError):
    pass


# OAuth
class OAuthClientError(interaction_errors.BaseInteractionError):
    params: Optional[MultiDict] = None

    def __init__(self, *, method, message=None, params=None):
        if params is not None:
            self.params = params
        super().__init__(service='oauth', method=method, message=message)


class OAuthInvalidGrantsClientError(OAuthClientError):
    pass
