from dataclasses import dataclass, field
from datetime import datetime
from enum import Enum
from typing import List


class MessageActor(Enum):
    OPERATOR = 'operator'
    CLIENT = 'client'


@dataclass
class Message:
    message_id: int
    text: str
    sender: MessageActor
    recipient: MessageActor
    creation_time: datetime
    attachments: List[dict] = field(default_factory=list)
