from mail.payments.payments.conf import settings
from mail.payments.payments.interactions.base import AbstractInteractionClient


class KassaClient(AbstractInteractionClient):
    SERVICE = 'kassa'
    BASE_URL = settings.KASSA_URL.rstrip('/')

    async def me(self, access_token: str) -> dict:
        return await self.get(interaction_method='me',
                              url=self.endpoint_url('api/v3/me'),
                              headers={'Authorization': f'Bearer {access_token}'})
