from mail.payments.payments.conf import settings
from mail.payments.payments.core.entities.bank_requisites import BankRequisites
from mail.payments.payments.interactions.base import AbstractInteractionClient
from mail.payments.payments.interactions.refs.exceptions import RefsClientNotFoundError


class RefsClient(AbstractInteractionClient):
    """Клиент для работы со справочной

    Справочная (refs) сервис-посредник, получающий и складирующий информацию извне для последующего
    предоставления потребителям внутри компании по средствам API https://wiki.yandex-team.ru/refs/
    """

    SERVICE = 'refs'
    BASE_URL = settings.REFS_API_URL

    async def cbrf_bank(self, bic: str) -> BankRequisites:
        assert bic

        url = self.endpoint_url('cbrf/')
        json = {'query': f'{{banks(bic:["{bic}"]) {{bic nameFull corr}}}}'}
        res_json = await self.post(interaction_method='refs_cbrf_bank', url=url, json=json)

        banks = res_json['data']['banks']
        if not banks:
            raise RefsClientNotFoundError()
        elif len(banks) > 1:
            self.logger.warning(f'Expected 1 bank in response, but was {len(banks)}')

        bank_requisites = banks[0]
        return BankRequisites(
            bic=bank_requisites['bic'],
            name_full=bank_requisites.get('nameFull', ''),
            corr=bank_requisites.get('corr', '')
        )
