from typing import Any, Dict, Optional

from aiohttp import ClientResponse

from sendr_qlog import LoggerContext

from mail.payments.payments.interactions.base import AbstractInteractionClient
from mail.payments.payments.storage.writers import PaymentsPushers


class ServiceClient(AbstractInteractionClient):
    """
    Client to make service callbacks to arbitrary (inner) service with TVM.
    It is not intended to be used as a part of `.clients` attribute on actions,
    because current implementation forces rule: one instance - one tvm id.
    We need to change `sendr_tvm.client.aiohttp.sessions_producer` if we want to allow
    instance of ServiceClient to handle many tvm ids.
    """

    SERVICE = 'arbitrary_service'

    def __init__(self,
                 tvm_id: int,
                 logger: LoggerContext,
                 request_id: Optional[str],
                 pushers: Optional[PaymentsPushers] = None):
        super().__init__(logger, request_id, pushers)
        self.tvm_id = tvm_id

    async def callback_service(self, url: str, json: Dict[str, Any]) -> ClientResponse:
        """Callback service URL with given JSON object."""
        return await self.post(
            interaction_method='callback_service',
            url=url, headers={}, json=json,
        )

    async def _process_response(self, response: ClientResponse, interaction_method: str) -> ClientResponse:
        if response.status >= 400:
            await self._handle_response_error(response)
        return response
