from typing import Any, Dict

from mail.payments.payments.conf import settings
from mail.payments.payments.interactions.base import AbstractInteractionClient


class SoClient(AbstractInteractionClient):
    SERVICE = 'so'
    BASE_URL = settings.SO_URL.rstrip('/')

    async def form_is_spam(self,
                           request_id: str,
                           form_id: str,
                           user_ip: str,
                           to_email: str,
                           from_email: str,
                           from_uid: int,
                           fields: Dict[str, Any],
                           body_template: str,
                           body: str) -> bool:
        response = await self.post(
            interaction_method='check_json',
            url=self.endpoint_url('check-json'),
            params={
                "service": settings.SO_SERVICE,
                "form_id": form_id,
                "id": request_id,
                "format": "json"
            },
            json={
                "client_ip": user_ip,
                "client_uid": from_uid,
                "client_email": from_email,
                "capture_type": None,
                "form_type": "user",
                "form_author": f"{from_uid}",
                "form_recipients": [to_email],
                "form_fields": dict(
                    (key, {"type": "string", "filled_by": "user", "value": str(value)})
                    for key, value in fields.items()
                ),
                "body": body,
                "body_template": body_template,
            }
        )

        return response['check']['spam']
