from typing import ClassVar, Optional

from mail.payments.payments.conf import settings
from mail.payments.payments.core.entities.enums import AcquirerType, TrustEnv

from .mcc import TrustMccClient
from .order import TrustOrderClient
from .partner import TrustPartnerClient
from .payment import TrustPaymentClient
from .payment_methods import TrustPaymentMethodsClient
from .product import TrustProductClient
from .refund import TrustRefundClient
from .subscription import TrustSubscriptionClient


class BaseTrustClient(TrustOrderClient,
                      TrustPartnerClient,
                      TrustPaymentClient,
                      TrustProductClient,
                      TrustSubscriptionClient,
                      TrustRefundClient,
                      TrustPaymentMethodsClient,
                      TrustMccClient):
    env: ClassVar[TrustEnv]


class TrustProductionClient(BaseTrustClient):
    SERVICE = 'trust-production'
    BASE_URL = settings.TRUST_URL
    env = TrustEnv.PROD


class TrustSandboxClient(BaseTrustClient):
    SERVICE = 'trust-sandbox'
    BASE_URL = settings.TRUST_SANDBOX_URL
    env = TrustEnv.SANDBOX

    def _get_service_token(self, uid: int, acquirer: AcquirerType) -> str:
        return settings.TRUST_SANDBOX_SERVICE_TOKEN

    @staticmethod
    def _make_product_id(uid: int, inn: str, partner_id: Optional[str], nds: str, service_fee: Optional[int]) -> str:
        uid = settings.TRUST_SANDBOX_PRODUCT_UID
        inn = settings.TRUST_SANDBOX_PRODUCT_INN
        partner_id = settings.TRUST_SANDBOX_PRODUCT_CLIENT_ID

        return f'{uid}.{inn}.{partner_id}.{nds}'
