from sendr_interactions import exceptions as interaction_errors


class TrustException(interaction_errors.BaseInteractionError):
    def __init__(self, *, method, message=None, params=None):
        super().__init__(service='trust', method=method, message=message)
        self.params = params


class UnknownTrustException(TrustException):
    pass


class TrustOrderAlreadyExists(TrustException):
    pass


class TrustInvalidState(TrustException):
    pass


class TrustUidNotFound(TrustException):
    pass
