from typing import List, Optional

from mail.payments.payments.core.entities.enums import AcquirerType

from .base import BaseTrustClient


class TrustMccClient(BaseTrustClient):
    async def mcc_get(self, acquirer: AcquirerType, uid: int, codes: Optional[List[int]] = None) -> List[dict]:
        """
        MCC-коды
        https://wiki.yandex-team.ru/TRUST/Payments/Mcc/
        """
        codes = codes or []
        url = self.endpoint_url('mcc')

        return await self.get(
            'mcc_get',
            url,
            acquirer=acquirer,
            uid=uid,
            params={'codes': ','.join(str(code) for code in codes)},
        )
