from mail.payments.payments.core.entities.enums import AcquirerType

from .base import BaseTrustClient


class TrustPartnerClient(BaseTrustClient):
    async def _partner_create(self, uid: int, acquirer: AcquirerType, partner_data: dict) -> dict:
        """
        Создание Партнера
        https://wiki.yandex-team.ru/TRUST/Payments/API/Partners/#sozdaniepartnera
        """
        url = self.endpoint_url('partners')
        return await self.post(
            '_partner_create',
            url,
            json=partner_data,
            uid=uid,
            acquirer=acquirer,
        )

    async def _partner_get(self, uid: int, acquirer: AcquirerType, partner_id: str) -> dict:
        """
        Информация о Партнере
        https://wiki.yandex-team.ru/TRUST/Payments/API/Partners/#informacijaopartnere
        """
        url = self.endpoint_url(f'partners/{partner_id}')
        return await self.get('_partner_get', url, uid=uid, acquirer=acquirer)
