from typing import Optional

from mail.payments.payments.core.entities.enums import AcquirerType
from mail.payments.payments.core.entities.merchant import Merchant
from mail.payments.payments.core.entities.subscription import Subscription

from .base import BaseTrustClient


class TrustProductClient(BaseTrustClient):
    async def _product_create(self, uid: int, acquirer: AcquirerType, product_data: dict) -> dict:
        """
        Создание Продукта
        https://wiki.yandex-team.ru/TRUST/Payments/API/Products/#sozdanieprodukta
        """
        url = self.endpoint_url('products')
        return await self.post(
            '_product_create',
            url,
            json=product_data,
            uid=uid,
            acquirer=acquirer,
        )

    async def _product_get(self, uid: int, acquirer: AcquirerType, product_id: str) -> dict:
        """
        Статус Продукта
        https://wiki.yandex-team.ru/TRUST/Payments/API/Products/#statusprodukta
        """
        url = self.endpoint_url(f'products/{product_id}')
        return await self.get('_product_get', url, uid=uid, acquirer=acquirer)

    async def product_create(self, uid: int, acquirer: AcquirerType, partner_id: Optional[str], nds: str,
                             inn: str, service_fee: Optional[int] = None) -> dict:
        product_data = self._make_product_data(uid, partner_id, nds, inn, service_fee)
        return await self._product_create(uid=uid, acquirer=acquirer, product_data=product_data)

    async def product_subscription_create(self,
                                          uid: int,
                                          acquirer: AcquirerType,
                                          merchant: Merchant,
                                          subscription: Subscription,
                                          ) -> dict:
        product_data = self._make_product_subscription_data(merchant, subscription)
        return await self._product_create(uid=uid, acquirer=acquirer, product_data=product_data)
