from dataclasses import dataclass
from enum import Enum, unique
from typing import Optional


@unique
class YandexPayAdminDocumentType(Enum):
    OFFER = 'offer'
    OTHER = 'other'
    PASSPORT = 'passport'
    POWER_OF_ATTORNEY = 'power_of_attorney'
    SIGNER_PASSPORT = 'signer_passport'
    PCI_DSS_CERT = 'pci_dss_cert'


@dataclass
class Document:
    path: str
    type: YandexPayAdminDocumentType
    name: Optional[str] = None


@dataclass
class Contact:
    email: str
    phone: str
    name: str
    surname: str
    patronymic: Optional[str] = None
