from marshmallow import Schema, fields
from marshmallow_enum import EnumField

from mail.payments.payments.interactions.yandex_pay_admin.entities import YandexPayAdminDocumentType


class BaseSchema(Schema):
    class Meta:
        strict = True


class DocumentSchema(BaseSchema):
    path = fields.String()
    name = fields.String()
    type = EnumField(YandexPayAdminDocumentType, by_value=True)


class UpdateModerationRequestSchema(BaseSchema):
    verified = fields.Boolean()
    documents = fields.Nested(DocumentSchema, many=True)
