from typing import ClassVar

from sendr_tvm import qloud_async_tvm
from sendr_tvm.client.aiohttp import CachedTvmTicketGetter

from mail.payments.payments.conf import settings
from mail.payments.payments.interactions.base import TVM_CONFIG, AbstractInteractionClient


class AbstractZoraClient(AbstractInteractionClient):
    """
    Sets zora as proxy for all requests.
    """
    SERVICE = 'zora'

    ZORA_VERIFY_CERT: ClassVar[bool] = False
    ZORA_SOURCE_NAME: ClassVar[str] = settings.ZORA_SOURCE_NAME

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.tvm_ticket_getter = CachedTvmTicketGetter(lambda: qloud_async_tvm.QTVM(**TVM_CONFIG))

    async def _make_request(self, interaction_method, method, url, **kwargs):
        kwargs['proxy'] = settings.ZORA_URL
        kwargs['verify_ssl'] = False
        kwargs['proxy_headers'] = await self.tvm_ticket_getter.get_service_ticket_headers(settings.TVM_ZORA_CLIENT_ID)
        kwargs.setdefault('headers', {}).update({
            'X-Ya-Ignore-Certs': 'false' if self.ZORA_VERIFY_CERT else 'true',
        })
        return await super()._make_request(interaction_method, method, url, **kwargs)
