from sendr_aiopg.storage import StorageAnnotatedMeta, StorageBase, StorageContextBase

from mail.payments.payments.storage.mappers.arbitrage import ArbitrageMapper
from mail.payments.payments.storage.mappers.category import CategoryMapper
from mail.payments.payments.storage.mappers.change_log import ChangeLogMapper
from mail.payments.payments.storage.mappers.common_data import CommonDataMapper
from mail.payments.payments.storage.mappers.functionality import FunctionalityMapper
from mail.payments.payments.storage.mappers.image import ImageMapper
from mail.payments.payments.storage.mappers.item import ItemMapper
from mail.payments.payments.storage.mappers.manager import ManagerMapper
from mail.payments.payments.storage.mappers.manager_role import ManagerRoleMapper
from mail.payments.payments.storage.mappers.merchant import MerchantMapper
from mail.payments.payments.storage.mappers.merchant_oauth import MerchantOAuthMapper
from mail.payments.payments.storage.mappers.merchant_preregistration import MerchantPreregistrationMapper
from mail.payments.payments.storage.mappers.moderation import ModerationMapper
from mail.payments.payments.storage.mappers.order.order import OrderMapper
from mail.payments.payments.storage.mappers.product import ProductMapper
from mail.payments.payments.storage.mappers.report import ReportMapper
from mail.payments.payments.storage.mappers.serial import SerialMapper
from mail.payments.payments.storage.mappers.service.service import ServiceMapper
from mail.payments.payments.storage.mappers.service.service_client import ServiceClientMapper
from mail.payments.payments.storage.mappers.service.service_merchant import ServiceMerchantMapper
from mail.payments.payments.storage.mappers.shop import ShopMapper
from mail.payments.payments.storage.mappers.subscription.customer_subscription import CustomerSubscriptionMapper
from mail.payments.payments.storage.mappers.subscription.customer_subscription_transaction import (
    CustomerSubscriptionTransactionMapper
)
from mail.payments.payments.storage.mappers.subscription.subscription import SubscriptionMapper
from mail.payments.payments.storage.mappers.task import TaskMapper
from mail.payments.payments.storage.mappers.transaction import TransactionMapper
from mail.payments.payments.storage.mappers.user import UserMapper
from mail.payments.payments.storage.mappers.user_role import UserRoleMapper
from mail.payments.payments.storage.mappers.worker import WorkerMapper


class Storage(StorageBase, metaclass=StorageAnnotatedMeta):
    arbitrage: ArbitrageMapper
    category: CategoryMapper
    change_log: ChangeLogMapper
    common_data: CommonDataMapper
    customer_subscription: CustomerSubscriptionMapper
    customer_subscription_transaction: CustomerSubscriptionTransactionMapper
    functionality: FunctionalityMapper
    image: ImageMapper
    item: ItemMapper
    manager: ManagerMapper
    manager_role: ManagerRoleMapper
    merchant: MerchantMapper
    merchant_oauth: MerchantOAuthMapper
    merchant_preregistration: MerchantPreregistrationMapper
    moderation: ModerationMapper
    order: OrderMapper
    product: ProductMapper
    report: ReportMapper
    serial: SerialMapper
    service: ServiceMapper
    service_client: ServiceClientMapper
    service_merchant: ServiceMerchantMapper
    shop: ShopMapper
    subscription: SubscriptionMapper
    task: TaskMapper
    transaction: TransactionMapper
    user: UserMapper
    user_role: UserRoleMapper
    worker: WorkerMapper


class StorageContext(StorageContextBase[Storage]):
    STORAGE_CLS = Storage
