from sendr_core.exceptions import BaseCoreError


class BaseLogbrokerException(BaseCoreError):
    pass


class UnknownLogbrokerException(BaseLogbrokerException):
    pass


class ClientNotInitializedException(BaseLogbrokerException):
    pass


class ConsumerStartFailedException(BaseLogbrokerException):
    pass


class ConsumerUnexpectedEventType(BaseLogbrokerException):
    pass


class ConsumerNotRunningException(BaseLogbrokerException):
    pass


class ConsumerMsgReleaseCannotCommitException(BaseLogbrokerException):
    pass


class ProducerNotRunningException(BaseLogbrokerException):
    pass


class ProducerStartFailedException(BaseLogbrokerException):
    pass


class ProducerWriteException(BaseLogbrokerException):
    pass


class ProducerAlreadyWrittenException(ProducerWriteException):
    pass


class ProducerWriteSeqNoMismatchException(ProducerWriteException):
    pass
